/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.ocean.thread;

import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Arrays;
import net.diebuddies.physics.ocean.OceanChunk;
import net.diebuddies.physics.ocean.OceanSearcher;
import net.diebuddies.physics.ocean.storage.StorageSimple;
import net.diebuddies.physics.vines.FastBlockSearcher;
import net.minecraft.class_2680;
import net.minecraft.class_2837;
import net.minecraft.class_2841;

public class OceanChunkCreator {
    private class_2841<class_2680> container;
    private byte data;
    private int chunkX;
    private int chunkY;
    private int chunkZ;

    public OceanChunkCreator(byte data, int chunkX, int chunkY, int chunkZ) {
        this.data = data;
        this.chunkX = chunkX;
        this.chunkY = chunkY;
        this.chunkZ = chunkZ;
    }

    public OceanChunkCreator(class_2841<class_2680> container, int chunkX, int chunkY, int chunkZ) {
        this.container = container;
        this.chunkX = chunkX;
        this.chunkY = chunkY;
        this.chunkZ = chunkZ;
    }

    public OceanChunk create() {
        if (this.container != null) {
            if (this.container.method_19526(OceanSearcher::isPhysicsOcean)) {
                OceanSearcher searcher = new OceanSearcher((class_2837<class_2680>)this.container.field_34560.comp_119());
                ((FastBlockSearcher)this.container.field_34560.comp_118()).getAllFast(searcher);
                IntList countData = searcher.getCountData();
                if (countData.size() == 1) {
                    return new OceanChunk(this.chunkX, this.chunkY, this.chunkZ, new StorageSimple((byte)(countData.getInt(0) >> 16), 4096));
                }
                byte[] rawData = new byte[4096];
                int offset = 0;
                for (int i = 0; i < countData.size(); ++i) {
                    int raw = countData.getInt(i);
                    int amount = raw & 0xFFFF;
                    byte data = (byte)(countData.getInt(i) >> 16);
                    Arrays.fill(rawData, offset, offset + amount, data);
                    offset += amount;
                }
                return new OceanChunk(this.chunkX, this.chunkY, this.chunkZ, new StorageSimple(rawData, 4096));
            }
            return new OceanChunk(this.chunkX, this.chunkY, this.chunkZ, new StorageSimple(-1, 4096));
        }
        return new OceanChunk(this.chunkX, this.chunkY, this.chunkZ, new StorageSimple(this.data, 4096));
    }

    public int getX() {
        return this.chunkX;
    }

    public int getY() {
        return this.chunkY;
    }

    public int getZ() {
        return this.chunkZ;
    }
}

